//	main.cpp

#include "DFGadget.h"
#include "colors.h"
#include "StLocker.h"


const float cWidth = 38.0;


class
MemoryApp : public BApplication
{

public:
					MemoryApp() : BApplication('?bbM'), 
								fGadget(NULL), fMap(NULL) {}
					~MemoryApp() { delete fGadget; }

	virtual void	ReadyToRun();
	virtual void	Pulse();

protected:
	
	DFGadget		*fGadget;
	BBitmap			*fMap;
	BView			*fView;
	
	long			fFaults;
	
	long			fHeight, fWidth;
};


void
MemoryApp::ReadyToRun()
{
	// request gadget
	
	fGadget = new DFGadget(cWidth+4.0, cWidth+4.0);
	
	fMap = new BBitmap(BRect(0,0,cWidth-1.0,16), B_COLOR_8_BIT, TRUE);
	
	fView = new BView(BRect(0,0,cWidth-1.0,16), "mem", B_FOLLOW_NONE, 0);
	fView->SetLowColor(mdGray);
	fMap->AddChild(fView);
		
	fMap->Lock();
	fView->FillRect(fView->Bounds());
	fView->SetLowColor(black);
	fView->SetHighColor(255,255,0);
	fView->Sync();
	fMap->Unlock();
			
	fGadget->SetBitmap(fMap);
	fGadget->SetOffset(BPoint(3,1), BPoint(3,9));
	
	SetPulseRate(1e6);
	
	// get sysInfo
	
	system_info info;
	get_system_info(&info);
	fFaults = info.page_faults;
	
	fHeight = 6;
	fWidth = fMap->BytesPerRow();
}	


void
MemoryApp::Pulse()
{
	char faults[6];
	
	if (fGadget) {
	
		system_info info;
		get_system_info(&info);

		fMap->Lock();
		fView->FillRect(BRect(0,0,cWidth-1.0,16), B_SOLID_LOW);

		sprintf(faults, "%5d", info.page_faults - fFaults);
		fView->DrawString(faults, BPoint(2,15));
		
		fView->Sync();
		
		char *p = (char*)fMap->Bits() + (2L * fWidth + 1L);
		
		for (long j=2; j<fHeight; j++)
		{
			long l = 36
				* info.used_pages / info.max_pages;
			
			if (l > 36) l = 36;
			if (l < 1) l = 1;
			memset(p, 146, l);
			
			long l2 = fWidth-l-2;
			if (l2 > 0)
				memset(p+l, 0, l2);
				
			p += fWidth;
		}
		
		fMap->Unlock();
		fGadget->Update();
		
		fFaults = info.page_faults;
	}
}
			

int
main()
{
	MemoryApp app;

	app.Run();

	return 0;
}
